
from cc3d.core.PySteppables import *

class fpp_projectSteppable(SteppableBasePy):

    def __init__(self,frequency=1):

        SteppableBasePy.__init__(self,frequency)

    def start(self):
        cell=self.new_cell(self.ECM)
        self.cell_field[0:self.dim.x, 0:50, 0] = cell
        
        #epithelia on top
        #create 30 cells
        xpos=0
        for numcells in range(30):
            lateral=self.new_cell(self.LATERAL)
            basal=self.new_cell(self.BASAL)
            self.reassign_cluster_id(basal,lateral.clusterId)
            apical=self.new_cell(self.APICAL)
            self.reassign_cluster_id(apical,lateral.clusterId)
            #create these cells in order first basal, then lateral then apical
            #assigning 40 pixels to basal, 120 to lateral and another 40 to apical 
            self.cell_field[xpos:xpos+10,50:54,0]=basal
            self.cell_field[xpos:xpos+10,54:66,0]=lateral
            self.cell_field[xpos:xpos+10,66:70,0]=apical
            xpos+=10      
            #volume properties
            lateral.targetVolume=120
            lateral.lambdaVolume=20
            basal.targetVolume=40
            basal.lambdaVolume=20
            apical.targetVolume=40
            apical.lambdaVolume=20
            #freezing the first and last cells
            if(numcells==0 or numcells==29):
                lateral.lambdaVolume=100
                basal.lambdaVolume=100
                apical.lambdaVolume=100 
        for cell in self.cell_list_by_type(self.APICAL):
            for neighbor, common_surface_area in self.get_cell_neighbor_data_list(cell):
                if neighbor:
                    if(neighbor.type==self.APICAL):
                        lambdaFP=10
                        targetDistance=6
                        self.focalPointPlasticityPlugin.createFocalPointPlasticityLink(cell,neighbor,lambdaFP,targetDistance,300.0)

        
    def step(self,mcs):
        if(mcs==500):
            for cell in self.cell_list_by_type(self.APICAL):
                if(100<cell.xCOM<200):
                    for fppd in self.get_focal_point_plasticity_data_list(cell):
                        lambdaFP=50
                        targetDistance=3.0
                        # arguments are (cell1,cell2,lambda,targetDistance,maxDistance)
                        self.focalPointPlasticityPlugin.setFocalPointPlasticityParameters(cell, fppd.neighborAddress, lambdaFP, targetDistance, 300.0)
                    
                    

    def finish(self):
        pass


        
